#pragma once
#include "afxcmn.h"
#include "afxwin.h"
#include "PropertyList.h"
#include "ListCtrlEx.h"
#include "ProfileDll.h"
#include "ServiceDlg.h"
#include "SMSCodec.h"
#include "SMSCodecDefines.h"
#include "ConfigSMS.h"
#include "FileUtil.h"


/////////////////////////////////////////////////////////////////////////////
// CServiceSMSDlg dialog
/////////////////////////////////////////////////////////////////////////////
class CServiceSMSDlg : public CServiceDlg
{
	DECLARE_DYNAMIC(CServiceSMSDlg)
private:
	virtual int		GetIconId()		{ return IDI_ICON_SMS; };
public:
	enum {	IDD = IDD_DLGSVC_SMS_MAIN	};
	CServiceSMSDlg(CService* iSvcSMS) : CServiceDlg(CServiceSMSDlg::IDD, theApp.m_hInstance, iSvcSMS){};
	virtual ~CServiceSMSDlg() {};	
protected:
	virtual void DoDataExchange(CDataExchange* pDX)	{ CDialog::DoDataExchange(pDX); };
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL	OnInitDialog()	{ CDialog::OnInitDialog(); return TRUE; };
	virtual char*	GetName()		{ return "SMS";};
	virtual void	UpdateDisplay()	{};
	virtual BOOL	Apply()			{ return TRUE; };
};
/////////////////////////////////////////////////////////////////////////////
//CServiceSMSDlgStorage Dialog
/////////////////////////////////////////////////////////////////////////////
#define	kStorageIndexCol			0	
#define	kStorageMsgTypeCol			1	
#define	kStorageMultiPartCol		2
#define	kStorageStateCol			3
#define	kStorageMsgTextCol			4
#define	kStorageColCount			kStorageMsgTextCol + 1
/////////////////////////////////////////////////////////////////////////////
class CServiceSMSDlgStorage : public CServiceDlg
{
	DECLARE_DYNAMIC(CServiceSMSDlgStorage)
public:
	CServiceSMSDlgStorage(CService* iSvcSMS) : CServiceDlg(CServiceSMSDlgStorage::IDD, theApp.m_hInstance, iSvcSMS)	{};
	virtual ~CServiceSMSDlgStorage(){};
	// Dialog Data
	enum { IDD = IDD_DLGSVC_SMS_STORAGE };
	virtual void	UpdateDisplay();
	virtual char*	GetName()	{ return "Storage - Received"; };
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply()		{return TRUE;};
	//
	CListCtrlEx		mStoredSMSList;
	CButton			mRefreshButton;
	CButton			mDeleteButton;
	//CButton		mSendButton;
	//virtual		void OnOK();
	//virtual		BOOL OnSetActive();
private:
	void SelectAll();

protected:
	int				mStorageIndexColWidth;
	virtual void	DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	void			InitSmsList();
	void			FillSmsList();
	DECLARE_MESSAGE_MAP()
	afx_msg void 	OnButtonRefresh();
	afx_msg void 	OnButtonDelete();
	afx_msg void 	OnDblclkListSms(NMHDR* pNMHDR, LRESULT* pResult);
	//afx_msg void	OnButtonSendtonwk();
public:
	afx_msg void OnHdnItemchangedDlgsvcSmsStoredList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnKeydownDlgsvcSmsStoredList(NMHDR *pNMHDR, LRESULT *pResult);
};
/////////////////////////////////////////////////////////////////////////////
//CServiceSMSDlgSent Dialog
/////////////////////////////////////////////////////////////////////////////
#define kSentIndexCol					0
#define kSentMultiPartCol				1
#define kSentStateCol					2
#define kSentReportCol					3
#define kSentMsgTextCol					4
#define	kSentColCount					kSentMsgTextCol + 1
/////////////////////////////////////////////////////////////////////////////
class CServiceSMSDlgSent : public CServiceDlg
{
	DECLARE_DYNAMIC(CServiceSMSDlgSent)
public:
	CServiceSMSDlgSent(CService* iSvcSMS) : CServiceDlg(CServiceSMSDlgSent::IDD, theApp.m_hInstance, iSvcSMS) {};
	virtual ~CServiceSMSDlgSent(){};
	enum { IDD = IDD_DLGSVC_SMS_SENT };		// Dialog Data
	virtual void	UpdateDisplay();
	virtual char*	GetName()	{ return "Storage - Sent"; };
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply()		{return TRUE;};
private:
	void SelectAll();
protected:
	virtual void	DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	void			InitSmsList();
	void			FillSmsList();
	afx_msg void	OnButtonRefresh();
	afx_msg void	OnButtonDelete();
	afx_msg void	OnButtonSendReport();
	afx_msg void	OnDblclkListSms(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void	OnLvnKeydownDlgsvcSmsSentList(NMHDR *pNMHDR, LRESULT *pResult);
	DECLARE_MESSAGE_MAP()
public:
	CListCtrlEx		mStoredSMSList;
	CButton			mRefreshButton, mSendReportButton, mDeleteButton;	
};
////////////////////////////////////////////////////////////////////////////
class CServiceSMSDlgPDUViewer : public CServiceDlg
{
	DECLARE_DYNAMIC(CServiceSMSDlgPDUViewer)
public:
	CServiceSMSDlgPDUViewer(CService* iSvcSMS):CServiceDlg(CServiceSMSDlgPDUViewer::IDD, theApp.m_hInstance, iSvcSMS)
		{mPduListP = mCurrentPduP = NULL;};
	virtual ~CServiceSMSDlgPDUViewer()	{ resetPtr(mPduListP); };	
	enum { IDD = IDD_DLGSVC_SMS_PDU_VIEWER };	// Dialog Data
	//Common interface
	virtual void	UpdateDisplay()	{};
	virtual char*	GetName()		{ return "PDU Viewer"; };
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply()			{ return TRUE; };	
	virtual void	SetParam(void* iParamP);
	virtual void	DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//Graphic attributes
	CEdit 			mPDUEdit;
	CComboBox 		mDirectionCombo;
	CButton 		mDecodeButton;
	CButton 		mPartPrevButton;
	CButton 		mPartNextButton;
	CStatic			mPartInfoStatic;
private:
	void			PrvBrowsePDUs(int iDir);
protected:
	CSMSPDU*		mPduListP;
	CSMSPDU*		mCurrentPduP;
	UInt16			mSmsDirection;
	afx_msg void	OnSMSDecodePDU();
	afx_msg void	OnPartPrev();
	afx_msg void	OnPartNext();

	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
//CServiceSMSDlgPDUMgr Dialog
/////////////////////////////////////////////////////////////////////////////
#define kNumberingPlanUnknown				129			// national / international unknown
#define kNumberingPlanInternational			145			// international number
#define kNumberingPlanNational				161			// national number
#define kSMSMaximumPDUSize					512

#define kSMSCenterTypeUnknownIndex			0
#define kSMSCenterTypeInternationalIndex	1
#define kSMSCenterTypeNationalIndex			2

#define kUnusedIndex						(int)-1
#define kCreationPurpose					0
#define kAnalyzePurpose						1

#define	kUpdateParamFromUI					0
#define	kUpdateUIFromParam					1
////////////////////////////////////////////////////////////////////////////
class CServiceSMSDlgPDUMgr : public CServiceDlg
{
	DECLARE_DYNAMIC(CServiceSMSDlgPDUMgr)
public:
	CServiceSMSDlgPDUMgr(CService* iSvcSMS);		
	virtual ~CServiceSMSDlgPDUMgr();
	enum { IDD = IDD_DLGSVC_SMS_PDU_MGR };	// Dialog Data
	//Common interface
	virtual void	UpdateDisplay(){};
	virtual char*	GetName()	{ return "PDU Manager"; };
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply()		{return TRUE;};	
	virtual void	DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void	SetParam(void* iParamP);
	void			ShowMsg(CSMS* iSMSMsgP);
	//Graphic attributes
	CEdit			mAddEdit;
	CComboBox		mTONCombo;
	CButton			mCfgInMsCheck, mReceivePDUButton, mCreatePDUBut;
	CPropertyList	mParamList;

private:
	void			PrvCreatePDU();
protected:
	//Private atributes
	int				mMtiReservedIndex;
	UInt16			mSmsDirection;
	CSMSCodec*		mSmsCodecP;
	CSMSPDU*		mSmsPduListP;
//	CCharSetString* mSmsPduP;
	CSMSParams*		mSmsParamP;
	CPropertyItem** itemsPP;
	int*			itemsIndexToIdP;
	int*			itemsIdToIndexP;
	int				mTagNumber, mExtTagNumber;
	CString			mSmsCenterAdd;	
	//Message handler
	afx_msg void 	OnSMSReceivePDU();
	afx_msg void 	OnSMSCreatePDU();
	afx_msg void 	OnSMSCenterConfiguration();
	afx_msg void	OnConfiguredInMS();		
	afx_msg void	OnBnClickedButtonResetpdu();
	afx_msg LRESULT OnPropertyChanged(WPARAM wItemChanged, LPARAM lReason);
	DECLARE_MESSAGE_MAP()
	//Private methodes
	virtual void	FreePropItemsData();
	virtual int		InitDataSet(int iIdentifier, int iIndex, int iPurpose, kSMSTPTagExt *ioTagTableP, int iTagTableSize);
	virtual BOOL	InitPropertyList(int iPurpose, kSMSType iSMSType);
	void 			UpdateSMSCenterTON(UInt8 iTON);
	void 			SetVisible(int iIndex, Bool iVisible);
	void 			ErrorNotify(CString iTitle, CString iStart, CString iEnd, int iItemIndex);
	void 			UpdateUIFromParamTable(void);
	BOOL 			CreateDefaultSMS(kSMSType iSMSType);	
	BOOL			CreatePropertyItem(int iIndex, int iIdentifier, CString propName, int curItemIndex, int nItemType, int nItemsNumber, SMS_TagText_Ptr nItemsTable, Bool nVisible, Bool nTitle);
	BOOL			CreatePropertyItem(int iIndex, int iIdentifier, CString propName, int curItemIndex, int nItemType, int nItemsNumber, SMS_TagText_Ptr nItemsTable, Bool nVisible, Bool nTitle, int nTextLimit, DWORD nTextType, CString nText);
	static void*	VPStrDup(const char* iString);
	//Tag Management
	static CTagCtrl tagCtrlTable[];				static int tagCtrlTableSize;
	
	static int	PrvIESTagToIESId(int iTag);
	static int  PrvIETagToIEId(int iTag);
	static int  PrvIEIdToIETag(int iId);

	static kSMSTPTagExt	xaTagTable[];			static int xaTagTableSize;
	static kSMSTPTagExt	vpTagTable[]; 			static int vpTagTableSize;
	static kSMSTPTagExt	piTagTable[]; 			static int piTagTableSize;
	static kSMSTPTagExt	udTagTable[]; 			static int udTagTableSize;
	static kSMSTPTagExt	dtTagTable[];			static int dtTagTableSize;
	static kSMSTPTagExt	sctsTagTable[];			static int sctsTagTableSize;
	static kSMSTPTagExt	pidTagTable[];			static int pidTagTableSize;
	static kSMSTPTagExt	dcsTagTable[];			static int dcsTagTableSize;

	void UpdateUI_MTI(int iItemId);
	void UpdateUI_DCS(int iItemId);
	void UpdateUI_PID(int iItemId);
	void UpdateUI_VPF(int iItemId);
	void UpdateUI_VP_E_F(int iItemId);
	void UpdateUI_PI_PID(int iItemId);
	void UpdateUI_PI_DCS(int iItemId);
	void UpdateUI_PI_UDL(int iItemId);
	void UpdateUI_UDHI(int iItemId);
	void UpdateUI_UD_C16(int iItemId);
	void UpdateUI_UD_C8(int iItemId);
	void UpdateUI_UD_S(int iItemId);
	void UpdateUI_UD_S_V(int iItemId);
	void UpdateUI_UD_S_F(int iItemId);
	void UpdateUI_UD_S_E(int iItemId);
	void UpdateUI_UD_S_O(int iItemId);
	void UpdateUI_UD_AP8(int iItemId);
	void UpdateUI_UD_AP16(int iItemId);
	void UpdateUI_UD_SMSC(int iItemId);
	void UpdateUI_UD_UDH(int iItemId);
	void UpdateUI_UD_WCMP(int iItemId);
	void UpdateUI_Time_Y(int iItemId);
	void UpdateUI_Time_Mo(int iItemId);
	void UpdateUI_Time_D(int iItemId);
	void UpdateUI_Time_H(int iItemId);
	void UpdateUI_Time_Mi(int iItemId);
	void UpdateUI_Time_S(int iItemId);
	void UpdateUI_Time_TZ(int iItemId);

	//Update mehodes
	static void PrvUpdateParamC(int iMode, int iTag, Tag* ioValue); // Combo
	static void PrvUpdateParamE(int iMode, int iTag, Tag* ioValue); // Edit
	static void PrvUpdateParamT(int iMode, int iTag, Tag* ioValue);	// Time
	static void PrvUpdateParamB(int iMode, int iTag, UInt8** ioBufPP);	// Buffer
	static void PrvUpdateParamIE(int iMode, int iTag, CSMSUserDataHeader* ioIElmtP);	// Information Element
	static void PrvUpdateParamIESC(int iMode, int iTag, int iIndex, CSMSUserDataHeader* ioIElmtP);	// Information Element Special Combo
	static void PrvUpdateParamIEC(int iMode, int iTag, int iIndex, CSMSUserDataHeader* ioIElmtP);	// Information Element Combo
	static void PrvUpdateParamIEE(int iMode, int iTag, int iIndex, CSMSUserDataHeader* ioIElmtP);	// Information Element Edit
	// Combo
	static void UpdateParam_MTI (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_MTI);}
	static void UpdateParam_MMS (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_MMS);}
	static void UpdateParam_VPF (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_VPF);}
	static void UpdateParam_SRI (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_SRx);}
	static void UpdateParam_SRR (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_SRx);}
	static void UpdateParam_SRQ (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_SRx);}
	static void UpdateParam_RP  (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_RP);}
	static void UpdateParam_CT  (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_CT);}
	static void UpdateParam_FCS (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_FCS);}
	static void UpdateParam_UDHI(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDHI);}
	static void UpdateParam_RD	(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_RD);}
	static void UpdateParam_ST  (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_ST);}
	static void UpdateParam_DCS_CG(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_DCS.codingGroup);}
	static void UpdateParam_DCS_C (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_DCS.compressed);}		
	static void UpdateParam_DCS_MCM(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_DCS.msgClassPresent);}
	static void UpdateParam_DCS_MCl(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_DCS.msgClass);}		
	static void UpdateParam_DCS_MCo(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_DCS.codingGroup);}	
	static void UpdateParam_DCS_A (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_DCS.alphabet);}		
	static void UpdateParam_DCS_I (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_DCS.indication);}		
	static void UpdateParam_DCS_IT (int iMode, int iTag, void* ioParams)
        {PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_DCS.indicationType);}	
	static void UpdateParam_PID_T (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_PID.type);}			
	static void UpdateParam_PID_TI (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_PID.teleInterw);}		
	static void UpdateParam_PID_TIT(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_PID.teleInterwType);}	
	static void UpdateParam_PID_SMT(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_PID.smType);}
	static void UpdateParam_PI_PID (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_PI.pid);}			
	static void UpdateParam_PI_DCS (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_PI.dcs);}			
	static void UpdateParam_PI_UDL (int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_PI.udl);}	
	static void UpdateParam_VP_E_EB(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.enhanced.extensionBit);}
	static void UpdateParam_VP_E_SS(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.enhanced.singleShot);}
	static void UpdateParam_VP_E_F(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.enhanced.format);}
	static void UpdateParam_AF_TON(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_xA.ton);}
	static void UpdateParam_AF_NPI(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamC(iMode, iTag, &((CSMSParams*)ioParams)->tp_xA.npi);}
	// Edit
	static void UpdateParam_MR(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamE(iMode, iTag, &((CSMSParams*)ioParams)->tp_MR);}
	static void UpdateParam_MN(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamE(iMode, iTag, &((CSMSParams*)ioParams)->tp_MN);}
	static void UpdateParam_PID_V(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamE(iMode, iTag, &((CSMSParams*)ioParams)->tp_PID.value);}
	static void UpdateParam_VP_V(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamE(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.relative);}
	static void UpdateParam_AF_Addr(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamB(iMode, iTag, &((CSMSParams*)ioParams)->tp_xA.valueP);}
	static void UpdateParam_xD_Data(int iMode, int iTag, void* ioParams);
	// Time
	static void UpdateParam_VP_Y(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.absolute[kSMSTime_Year]);}
	static void UpdateParam_VP_Mo(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.absolute[kSMSTime_Month]);}
	static void UpdateParam_VP_D(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.absolute[kSMSTime_Day]);}
	static void UpdateParam_VP_H(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.absolute[kSMSTime_Hour]);}
	static void UpdateParam_VP_Mi(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.absolute[kSMSTime_Minute]);}
	static void UpdateParam_VP_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.absolute[kSMSTime_Second]);}
	static void UpdateParam_VP_TZ(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_VP.absolute[kSMSTime_TimeZone]);}
	
	static void UpdateParam_DT_Y(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_DT[kSMSTime_Year]);}
	static void UpdateParam_DT_Mo(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_DT[kSMSTime_Month]);}
	static void UpdateParam_DT_D(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_DT[kSMSTime_Day]);}
	static void UpdateParam_DT_H(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_DT[kSMSTime_Hour]);}
	static void UpdateParam_DT_Mi(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_DT[kSMSTime_Minute]);}
	static void UpdateParam_DT_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_DT[kSMSTime_Second]);}
	static void UpdateParam_DT_TZ(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_DT[kSMSTime_TimeZone]);}

	static void UpdateParam_SCTS_Y(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_SCTS[kSMSTime_Year]);}
	static void UpdateParam_SCTS_Mo(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_SCTS[kSMSTime_Month]);}
	static void UpdateParam_SCTS_D(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_SCTS[kSMSTime_Day]);}
	static void UpdateParam_SCTS_H(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_SCTS[kSMSTime_Hour]);}
	static void UpdateParam_SCTS_Mi(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_SCTS[kSMSTime_Minute]);}
	static void UpdateParam_SCTS_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_SCTS[kSMSTime_Second]);}
	static void UpdateParam_SCTS_TZ(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamT(iMode, iTag, &((CSMSParams*)ioParams)->tp_SCTS[kSMSTime_TimeZone]);}
	// User Data Header
	static void UpdateParam_UD_C8(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_C16(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_AP8(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_AP16(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_SMSC(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_UDH(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_WCMP(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_STKH(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_SME(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_SCSp(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIE(iMode, iTag, &((CSMSParams*)ioParams)->tp_UDH);}
	//
	static void UpdateParam_UD_S_V(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIESC(iMode, iTag, kSMSIEType_SpecialVoice, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_F(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIESC(iMode, iTag, kSMSIEType_SpecialFax, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_E(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIESC(iMode, iTag, kSMSIEType_SpecialEMail, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_O(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIESC(iMode, iTag, kSMSIEType_SpecialOther, &((CSMSParams*)ioParams)->tp_UDH);}
	//
	static void UpdateParam_UD_S_V_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SpecialVoice, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_F_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SpecialFax, 	 &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_E_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SpecialEMail, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_O_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SpecialOther, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_SMSC_S_P(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SMSCControl, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_SMSC_S_T_A(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SMSCControl, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_SMSC_S_T_T(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SMSCControl, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_SMSC_S_Co(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SMSCControl, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_SMSC_S_Ca(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SMSCControl, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_SMSC_S_I(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_SMSCControl, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_UDH_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEC(iMode, iTag, kSMSIEType_UDHSourceInd, &((CSMSParams*)ioParams)->tp_UDH);}
	// 
	static void UpdateParam_UD_Cx_R(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_Concat8BRef, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_Cx_M(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_Concat8BRef, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_Cx_S(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_Concat8BRef, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_V_C(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_SpecialVoice, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_F_C(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_SpecialFax, 	 &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_E_C(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_SpecialEMail, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_S_O_C(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_SpecialOther, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_APx_D(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_AppPort8B, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_APx_O(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_AppPort8B, &((CSMSParams*)ioParams)->tp_UDH);}
	static void UpdateParam_UD_WCMP_PDU(int iMode, int iTag, void* ioParams)
		{PrvUpdateParamIEE(iMode, iTag, kSMSIEType_WirelessCont, &((CSMSParams*)ioParams)->tp_UDH);}	
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
